{{ *********************************************************
   *  Example QC Test : For "ET-BASE PX32 V1.0             *
   *                                                       *
   *  File Name       : QC_Multi_Test.spin                 *
   *  Compiler        : Propeller V1.06                    *
   *  Create By       : Sittiphol Yooyod (www.ett.co.th)   *
   *  Last Update     : 28/January/2007                    *
   *  Function        : For Test Mouse,Keyboard,MIC,Audio, *
   *                    Port P0..P7 LED Blinky             *                  
   *                                                       *
   ********************************************************* }}

  
CON

  

    _clkmode        = xtal1 + pll16x   ''Set PLL = x16
    _xinfreq        = 5_000_000        ''Crystal 5.0 Mhz ;System Clock =16x5=80Mhz


  ''************ Initial VGA **************
      
    cols = 32                          ''Screen :15 row x 32 Colum
    rows = 15

    screensize = cols * rows
    lastrow = screensize - cols

    vga_count = 21

    bits = 11                          ''try different values from table here


  ''************ Initial TV (Screen 640x480 Pixel) **************
      
       T_cols = 40
       T_rows = 13

       T_screensize = T_cols * T_rows
       T_lastrow = T_screensize - T_cols

       tv_count = 14

  
VAR

  long  col, row, color, flag,fag
  
  word  screen[screensize]
  long  colors[8 * 2]

  long  vga_status    '0/1/2 = off/visible/invisible      read-only   (21 longs)
  long  vga_enable    '0/non-0 = off/on                   write-only
  long  vga_pins      '%pppttt = pins                     write-only
  long  vga_mode      '%tihv = tile,interlace,hpol,vpol   write-only
  long  vga_screen    'pointer to screen (words)          write-only
  long  vga_colors    'pointer to colors (longs)          write-only            
  long  vga_ht        'horizontal tiles                   write-only
  long  vga_vt        'vertical tiles                     write-only
  long  vga_hx        'horizontal tile expansion          write-only
  long  vga_vx        'vertical tile expansion            write-only
  long  vga_ho        'horizontal offset                  write-only
  long  vga_vo        'vertical offset                    write-only
  long  vga_hd        'horizontal display ticks           write-only
  long  vga_hf        'horizontal front porch ticks       write-only
  long  vga_hs        'horizontal sync ticks              write-only
  long  vga_hb        'horizontal back porch ticks        write-only
  long  vga_vd        'vertical display lines             write-only
  long  vga_vf        'vertical front porch lines         write-only
  long  vga_vs        'vertical sync lines                write-only
  long  vga_vb        'vertical back porch lines          write-only
  long  vga_rate      'tick rate (Hz)                     write-only

  long stack[400]
  

  ''******************* TV ********************

  long  T_col, T_row, T_color, T_flag
  
  word  T_screen[T_screensize]
  long  T_colors[8 * 2]

  long  tv_status     '0/1/2 = off/invisible/visible              read-only   (14 longs)
  long  tv_enable     '0/non-0 = off/on                           write-only
  long  tv_pins       '%pppmmmm = pin group, pin group mode       write-only
  long  tv_mode       '%tccip = tile,chroma,interlace,ntsc/pal    write-only
  long  tv_screen     'pointer to screen (words)                  write-only      
  long  tv_colors     'pointer to colors (longs)                  write-only                            
  long  tv_ht         'horizontal tiles                           write-only                            
  long  tv_vt         'vertical tiles                             write-only                            
  long  tv_hx         'horizontal tile expansion                  write-only                            
  long  tv_vx         'vertical tile expansion                    write-only                            
  long  tv_ho         'horizontal offset                          write-only                            
  long  tv_vo         'vertical offset                            write-only                            
  long  tv_broadcast  'broadcast frequency (Hz)                   write-only                            
  long  tv_auralcog   'aural fm cog                               write-only                            

  long  mousex, mousey
  
OBJ

  vga   : "vga"
  kb    : "keyboard"
 
  tv    : "tv"                ''Include Function in File TV.spin
  mouse : "mouse"

  
PUB main | receive  

  cognew(@asm_entry, 0)      ''Mic to Headphone       
  cognew(Blink, @stack[0])   ''LED Blinky      
  cognew(MTV,@stack[10])
  cognew(KVGA,@stack[200])  

 
 


PUB KVGA  |ch
 ''***************** Key On VGA ****************
 
 ''--------- Start VGA PIN 16..23 ----------- 
   start(16)                           
   
 ''------ Start keyboard ---------
  
   kb.start(26, 27)
     
  repeat  
    out(0)
    fag := 0
    str(string(13,12,2,"  ..ETT DEMO Key Board On VGA..",13))  '' Sent Megsage ON VGA
    str(string(13,12,1,"Enter Key : "))                        '' Sent Megsage ON VGA
    out(12)
    out(3)
  
    repeat until fag == 1      
      ch := kb.getkey                                          ''Read key 
      out(ch)
      if row == 14  
         fag := 1
   


''*************** Function Test LED *****************

PUB Blink
    
    dira[0..7]~~                      ''Set Pin0..7 = Output(1)
    
    repeat        
        OutA := $00                   ''LED ON
        WaitCnt(40_000_000+ cnt)      ''Delay     
        OutA := $FF                   ''LED OFF
        WaitCnt(40_000_000+ cnt)      ''Delay


                                                 
''**************** Function For Key On VGA ******************
              
PUB start(basepin) : okay

'' Start terminal - starts a cog
'' returns false if no cog available
''
'' requires at least 80MHz system clock
 
  setcolors(@palette)
  out(0)
  
  longmove(@vga_status, @vga_params, vga_count)
  vga_pins := basepin | %000_111
  vga_screen := @screen
  vga_colors := @colors
  vga_rate := clkfreq >> 2
  
  okay := vga.start(@vga_status)
  


PUB stop

'' Stop terminal - frees a cog

  vga.stop


PUB str(stringptr)

'' Print a zero-terminated string

  repeat strsize(stringptr)
    out(byte[stringptr++])



PUB out(c) | i, k

'' Output a character
''
''     $00 = clear screen
''     $01 = home
''     $08 = backspace
''     $09 = tab (8 spaces per)
''     $0A = set X position (X follows)
''     $0B = set Y position (Y follows)
''     $0C = set color (color follows)
''     $0D = return
''  others = printable characters

  case flag
    $00: case c
           $00: wordfill(@screen, $220, screensize)
                col := row := 0
           $01: col := row := 0
           $08: if col
                  col--
           $09: repeat
                  print(" ")
                while col & 7
           $0A..$0C: flag := c
                     return
           $0D: newline
           other: print(c)
    $0A: col := c // cols
    $0B: row := c // rows
    $0C: color := c & 7
  flag := 0


PUB setcolors(colorptr) | i, fore, back

'' Override default color palette
'' colorptr must point to a list of up to 8 colors
'' arranged as follows (where r, g, b are 0..3):
''
''               fore   back
''               ------------
'' palette  byte %%rgb, %%rgb     'color 0
''          byte %%rgb, %%rgb     'color 1
''          byte %%rgb, %%rgb     'color 2
''          ...

  repeat i from 0 to 7
    fore := byte[colorptr][i << 1] << 2
    back := byte[colorptr][i << 1 + 1] << 2
    colors[i << 1]     := fore << 24 + back << 16 + fore << 8 + back
    colors[i << 1 + 1] := fore << 24 + fore << 16 + back << 8 + back


PRI print(c)

  screen[row * cols + col] := (color << 1 + c & 1) << 10 + $200 + c & $FE
  if ++col == cols
    newline


PRI newline | i

  col := 0
  ++row



  
''*********************** Function Mouse ON TV ***********************

PUB MTV |click,y

   T_start(12)                            ''Start TV PIN 12..15
                    
   '-------------- Start mouse --------------
  
  mouse.start(24, 25)
  mousex := 19      ''Set Position Mouse X,Y: Display On TV ,0-38:L to R
  mousey := 6        ''1-12 :On to botton
  

Repeat

   '--------- Draw mouse pointe --------   
    T_out(0) 
    T_str(string(12,2,"        ...ETT DEMO MOUSE ON TV...",13))  ''Sent Megsage ON TV    
    mousex := mousex + (mouse.delta_x/5) #> 1 <# 37              ''Update Position Mouse x
    mousey := mousey + (mouse.delta_y/15)#> 1 <# 12              ''Update Position Mouse y
    y      := 13-mousey
    
    T_out($0A)
    T_out(mousex)
    T_out($0B)
    T_out(y)
    T_out(12)
    T_out(6)
    T_out($0E)

  
    WaitCnt(20_000_000 + Cnt) ''delay 500 ms  


    click := mouse.buttons                           ''Read Mouse Button 

    repeat while click == 2                          ''Click Left
       T_str(string(10,25,11,6,12,5,"CLICK Right"))  '' Sent Megsage ON TV     
       click := mouse.buttons  
    repeat while click == 1                          ''Click Left
       T_str(string(10,5,11,6,12,3,"CLICK LEFT"))    ''Sent Megsage ON TV     
       click := mouse.buttons

    repeat while click == 4                          ''Click Left
       T_str(string(10,17,11,6,12,1,"Scroll"))       ''Sent Megsage ON TV     
       click := mouse.buttons     

   

   
       
'----------------------------- SUB Program -------------------------------------

  
PUB T_start(basepin) : okay

'' Start terminal - starts a cog
'' returns false if no cog available

  T_setcolors(@color0)                         'Set Start Color Screen Black and Text white
  T_out(0)
  
  longmove(@tv_status, @tv_params, tv_count)
  tv_pins := (basepin & $38) << 1 | (basepin & 4 == 4) & %0101
  tv_screen := @T_screen
  tv_colors := @T_colors
  
  okay := tv.start(@tv_status)


PUB T_stop

'' Stop terminal - frees a cog

  tv.stop


PUB T_str(stringptr)

'' Print a zero-terminated string

  repeat strsize(stringptr)
    T_out(byte[stringptr++])



PUB T_out(c) | i, k

'' Output a character
''
''     $00 = clear screen
''     $01 = home
''     $08 = backspace
''     $09 = tab (8 spaces per)
''     $0A = set X position (X follows)
''     $0B = set Y position (Y follows)
''     $0C = set color (color follows)
''     $0D = return
''  others = printable characters

  case T_flag
    $00: case c
           $00: wordfill(@T_screen, $220, T_screensize)    '220
                T_col := T_row := 0
           $01: T_col := T_row := 0
           $08: if T_col
                  T_col--
           $09: repeat
                  T_print(" ")
                while T_col & 7
           $0A..$0C: T_flag := c
                     return
           $0D: T_newline
           other: T_print(c)
    $0A: T_col := c // T_cols
    $0B: T_row := c // T_rows
    $0C: T_color := c & 7
  T_flag := 0


  
PUB T_setcolors(colorptr) | i, fore, back

'' Override default color palette
'' colorptr must point to a list of up to 8 colors
'' arranged as follows:
''
''               fore   back
''               ------------
'' palette  byte color, color     'color 0
''          byte color, color     'color 1
''          byte color, color     'color 2
''          ...

  repeat i from 0 to 7
    fore := byte[colorptr][i << 1]
    back := byte[colorptr][i << 1 + 1]
    T_colors[i << 1]     := fore << 24 + back << 16 + fore << 8 + back
    T_colors[i << 1 + 1] := fore << 24 + fore << 16 + back << 8 + back


PRI T_print(c)

  T_screen[T_row * T_cols + T_col] := (T_color << 1 + c & 1) << 10 + $200 + c & $FE
  if ++T_col == T_cols
    T_newline


PRI T_newline | i

  T_col := 0
  if ++T_row == T_rows
    T_row--
    wordmove(@T_screen, @T_screen[cols], T_lastrow)   ''scroll lines
    wordfill(@T_screen[T_lastrow], $220, T_cols)      ''clear new line

  
DAT

vga_params              long    0               'status
                        long    1               'enable
                        long    0               'pins
                        long    %1000           'mode
                        long    0               'videobase
                        long    0               'colorbase
                        long    cols            'hc
                        long    rows            'vc
                        long    1               'hx
                        long    1               'vx
                        long    0               'ho
                        long    0               'vo
                        long    512             'hd 
                        long    10              'hf
                        long    75              'hs
                        long    43              'hb
                        long    480             'vd
                        long    11              'vf
                        long    2               'vs
                        long    31              'vb
                        long    0               'rate

                        '        fore   back
                        '         RGB    RGB
palette                 byte    %%300, %%000    '0       Red / black
                        byte    %%330, %%000    '1    yellow / black
                        byte    %%300, %%000    '2       Red / black
                        byte    %%333, %%00     '3     white / black
                        byte    %%033, %%011    '4      cyan / dark cyan
                        byte    %%030, %%003    '5     green / blue
                        byte    %%311, %%003    '6      pink / blue
                        byte    %%300, %%000    '7      RED  / black
                            
 ''************************** TV ****************

 tv_params               long    0               'status
                        long    1               'enable
                        long    0               'pins
                        long    %10010          'mode
                        long    0               'screen
                        long    0               'colors
                        long    T_cols            'hc
                        long    T_rows            'vc
                        long    4               'hx
                        long    1               'vx
                        long    0               'ho
                        long    0               'vo
                        long    0               'broadcast
                        long    0               'auralcog



                      'Text Color  'Screen&Back-Ground Colour
color0            byte     $2E,        $02    '0    white    Text  / Black Screen 
                  byte     $98,        $02    '1    Sky      Text  / Black Screen
                  byte     $EE,        $02    '2    Pink     Text  / Black Screen
                  byte     $1E,        $01    '3    Violet   Teat  / Black Screen      
                  byte     $02,        $02    '4    Black    Text  / Black Screen
                  byte     $9E,        $01    '5    Yellow   Text  / Black Screen
                  byte     $38,        $01    '6    Red      Text  / Black Screen
                  byte     $EE,        $7C    '7    Pink     Text  / Green Screen

                        
''********************* Function Test Mic to Headphone **********************

 ' Assembly program

              org

asm_entry     mov       dira,asm_dira                   'make pins 8 (ADC) and 0 (DAC) outputs

              movs      ctra,#8                         'POS W/FEEDBACK mode for CTRA
              movd      ctra,#9
              movi      ctra,#%01001_000
              mov       frqa,#1

              movs      ctrb,#10                        'DUTY DIFFERENTIAL mode for CTRB
              movd      ctrb,#11
              movi      ctrb,#%00111_000
              
              mov       asm_cnt,cnt                     'prepare for WAITCNT loop
              add       asm_cnt,asm_cycles

              
:loop         waitcnt   asm_cnt,asm_cycles              'wait for next CNT value (timing is determinant after WAITCNT)

              mov       asm_sample,phsa                 'capture PHSA and get difference
              sub       asm_sample,asm_old
              add       asm_old,asm_sample
                                                         
              shl       asm_sample,#32-bits             'justify sample and output to FRQB
              mov       frqb,asm_sample
    
              jmp       #:loop                          'wait for next sample period


' Data
asm_cycles    long      |< bits - 1                     'sample time
asm_dira      long      $00000E00                       'output mask

asm_cnt       res       1
asm_old       res       1
asm_sample    res       1

